Summary: Library for Qtopia application development





Name: qtopia-free
Version: 1.5.0
Release: 1
Copyright: Trolltech
Group: System Environment/Base
Source0: qt-x11-2.3.2.tar.gz
Source1: qt-embedded-2.3.3.tar.gz
Source2: qtopia-free-1.5.0.tar.gz
Source3: tmake-1.8.tar.gz
Patch0: tmake18.patch
#Patch1: qte232b.patch
BuildRoot: /var/tmp/%{name}

%description
Qtopia is the windowing system of the SHARP SL5000 and similar
handheld Embedded Linux devices. It combines the Qt/Embedded
and Qtopia library into a device-oriented package for development
of Free Software Qtopia applications.

%prep
#$RPM_SOURCE_DIR
rm -rf qt-2.3.3
rm -rf qtopia-free-${RPM_PACKAGE_VERSION}
rm -rf $RPM_PACKAGE_NAME-$RPM_PACKAGE_VERSION
ln -s qt-2.3.3 $RPM_PACKAGE_NAME-$RPM_PACKAGE_VERSION
%setup -q -T -c -a 0
mv qt-2.3.2 qt-x11-2.3.2
%setup -q -T -D -c -a 1
%setup -q -T -D -c -a 2
%setup -q -T -D -c -a 3
%patch0 -p0
#%patch1 -p0
%build
#Build Qt/X11 tools statically: uic, designer, moc, qvfb
export QTDIR=$PWD/qt-x11-2.3.2
cd $QTDIR
echo yes | ./configure -static -no-xft -no-opengl -no-sm
make -C src/moc
cp src/moc/moc bin
make -C src
make -C tools/designer
make -C tools/qvfb
cp tools/qvfb/qvfb bin
strip bin/uic bin/moc bin/designer bin/qvfb
make clean
cd ..
#Build Qt/Embedded
export QTXDIR=$PWD/qt-x11-2.3.2
export QTDIR=$PWD/qt-2.3.3
export QPEDIR=$PWD/qtopia-free-${RPM_PACKAGE_VERSION}
cp -f $QTXDIR/bin/?* $QTDIR/bin/
cd $QTDIR
cp $QPEDIR/qt/qconfig-qpe.h $QTDIR/src/tools
#... for SHARP
echo yes | ./configure -xplatform linux-sharp-g++ -qconfig qpe -depths 16,32 -no-qvfb
make -C src/moc
cp src/moc/moc bin
make -C src
cp -a lib lib-sharp
make clean
#... for host architecture
echo yes | ./configure -qconfig qpe -depths v,4,8,16,24,32 -qvfb
make -C src

cd ..
#Build Qt Palmtop library
cd $QPEDIR
#... for SHARP
./configure -platform sharp
mv $QTDIR/lib $QTDIR/lib-host
mv $QTDIR/lib-sharp $QTDIR/lib

for i in library taskbar taskbar/batteryapplet taskbar/clockapplet     taskbar/netmonapplet inputmethods/pickboard inputmethods/handwriting     inputmethods/unikeyboard inputmethods/keyboard helpbrowser addressbook     datebook textedit netsetup/dialup netsetup/lan mpegplayer/libmpeg3     mpegplayer/libmad mpegplayer/wavplugin cardmon calculator clock filebrowser     minesweep mpegplayer embeddedkonsole taskbar sysinfo citytime showimg     netsetup qipkg mindbreaker todo     qcop settings/light-and-power settings/language settings/appearance     settings/security settings/systemtime

do
    make -C $i
done
cp -a bin bin-sharp
mv $QTDIR/lib $QTDIR/lib-sharp
mv $QTDIR/lib-host $QTDIR/lib
make clean
#... for host architecture
./configure

for i in library taskbar taskbar/batteryapplet taskbar/clockapplet     taskbar/netmonapplet inputmethods/pickboard inputmethods/handwriting     inputmethods/unikeyboard inputmethods/keyboard helpbrowser addressbook todo     datebook textedit netsetup/dialup netsetup/lan mpegplayer/libmpeg3     mpegplayer/libmad mpegplayer/wavplugin cardmon calculator clock filebrowser     minesweep mpegplayer embeddedkonsole taskbar sysinfo citytime showimg     netsetup qipkg mindbreaker     qcop settings/light-and-power settings/language settings/appearance     settings/security settings/systemtime

do
    make -C $i
done
%install
export QTDIR=$PWD/qt-2.3.3
export QPEDIR=$PWD/qtopia-free-${RPM_PACKAGE_VERSION}
QT=$RPM_BUILD_ROOT/opt/Qtopia
rm -rf $QT
mkdir -p $QT
mkdir -p $QT/apps/Applications
mkdir -p $QT/apps/Games
mkdir -p $QT/apps/Settings

for i in addressbook todo calculator citytime clock datebook embeddedkonsole     filebrowser helpbrowser mpegplayer showimg sysinfo textedit todo 

do
    cp $QPEDIR/apps/Applications/$i.desktop $QT/apps/Applications
done
cp $QPEDIR/apps/Applications/.directory $QT/apps/Applications
for i in Language Appearance Calibrate Light Security datetime netsetup qipkg quit
do
    cp $QPEDIR/apps/Settings/$i.desktop $QT/apps/Settings
done
cp $QPEDIR/apps/Settings/.directory $QT/apps/Settings
mkdir -p $QT/etc
mkdir -p $QT/pics
mkdir -p $QT/help/html $QT/help/de/html
mkdir -p $QT/sharp
mkdir -p $QT/sharp/apps/Applications
mkdir -p $QT/sharp/apps/Games
mkdir -p $QT/sharp/apps/Settings
mkdir -p $QT/sharp/help/html
mkdir -p $QT/sharp/pics
cp -a $QTDIR/lib/ $QT
cp -a $QTDIR/lib-sharp/ $QT/sharp/lib

#GNU Cpp appears broken, hence the following...
cp -r $QPEDIR/pics/?*.png $QT/pics
cp -r $QPEDIR/pics/?*.png $QT/sharp/pics
rm -rf $QT/sharp/lib/fonts
ln -s ../../lib/fonts $QT/sharp/lib
rm -rf $QTDIR/include/qxt.h # not connected
#cp -r $QTDIR/include $QT
(cd $QTDIR && tar cfh - include) | (cd $QT && tar xf - )
#cp -r $QPEDIR/include/qpe $QT/include/qpe
(cd $QPEDIR/include && tar cfh - qpe) | (cd $QT/include && tar xf - )
mkdir -p $QT/doc
cp -r $QTDIR/doc $QT/doc/qt
cp -r $QPEDIR/doc/index.html $QT/doc
cp -r $QPEDIR/doc/qtopia $QT/doc/qtopia
cp -r $QTDIR/bin $QT
cp -a $QPEDIR/mkipks $QT/bin
cp -a $QPEDIR/bin-sharp $QT/sharp/bin
cp -a $QPEDIR/bin/?* $QT/bin
cp -a $QPEDIR/plugins $QT/plugins
cp -a $QPEDIR/etc/qimpen $QT/etc
rm -f $QT/etc/qimpen/quick*
cp -a $QPEDIR/example $QT
cp $QPEDIR/LICENSE* $QT
mv $QT/example/README $QT
mv $QT/example/index.html $QT/help/html/
cp -a tmake-* $QT/tmake
cp $(which mkfs.jffs2) $QT/bin
ln -s ../tmake/bin/tmake $QT/bin
( cd $QT/sharp/bin; ln -s ../../bin/?* .; )
ln -s ../include $QT/sharp
%clean
%files
%defattr(-,root,root)

/opt/Qtopia

%changelog
